function [B] = rot90f(A,k)
[%nargout,%nargin] = argn(0)
//ROT90  Rotate matrix 90 degrees.
//   ROT90(A) is the 90 degree counterclockwise rotation of matrix A.
//   ROT90(A,K) is the K*90 degree rotation of A, K = +-1,+-2,...
[m,n] = size(A);
if %nargin==1 then
  k = 1;
else
  k = k-fix(k/4).*4;
  if(k<0) then
    k = k+4;
  end
end
if k == 1
            A = A.';
            B = A(n:-1:1,:);
elseif k == 2
            B = A(m:-1:1,n:-1:1);
elseif k == 3
            B = A(m:-1:1,:);
            B = B.';
else
            B = A;
end
endfunction
